function addParam(ssm, name, val)
%ADDPARAM Add a parameter to a StateSpaceModel object
% A DynamicElement with a def and label of 'p.<name>' and val as given will be added to ssm.p. 
% The variable name will be ssm.p.<name>
% ssm - A StateSpaceModel object
% def - The name of the parameter to be added
% val - The value of the parameter to be added
%
% Example:
%   addParam(ssm,'param1',0)
%   creates m.p.param1 as a DynamicElement with properties:
%     def: 'p.param1'
%     val: 0
%     label: 'p.param1'

% David Katzin, Wageningen University
% david.katzin@wur.nl

    if ~exist('val','var')
        val = [];
    end
    
    if ~isa(name,'char')
        error('label must be a character vector');
    end

    ssm.p.(name) = DynamicElement(['p.' name], val, ['p.' name], val);
end

